/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.dynamicsf.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import me.andre111.dynamicsf.DynamicSoundFilters;

public class ConfigHelper {
    public static <K, V> Map<K, V> parseToMap(List<String> entries, Function<String, K> keyParser, Function<String, V> valueParser) {
        HashMap<K, V> map = new HashMap<K, V>();
        if (entries != null) {
            for (String entry : entries) {
                try {
                    if (entry == null) {
                        throw new RuntimeException();
                    }
                    String[] split = entry.split(";");
                    if (split.length != 2) {
                        throw new RuntimeException();
                    }
                    K key = keyParser.apply(split[0]);
                    V value = valueParser.apply(split[1]);
                    map.put(key, value);
                }
                catch (RuntimeException e) {
                    DynamicSoundFilters.getLogger().error("Ignoring broken config entry: " + entry, (Throwable)e);
                }
            }
        }
        return map;
    }

    public static <K> Set<K> parseToSet(List<String> entries, Function<String, K> keyParser) {
        Set set = Collections.newSetFromMap(new HashMap());
        if (entries != null) {
            for (String entry : entries) {
                try {
                    if (entry == null) {
                        throw new RuntimeException();
                    }
                    K key = keyParser.apply(entry);
                    set.add(key);
                }
                catch (RuntimeException e) {
                    DynamicSoundFilters.getLogger().error("Ignoring broken config entry: " + entry, (Throwable)e);
                }
            }
        }
        return set;
    }
}

